<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DisplayVideo;

class OnScreenPositionAssignedTargetingOptionDetails extends \Google\Model
{
  /**
   * @var string
   */
  public $adType;
  /**
   * @var string
   */
  public $onScreenPosition;
  /**
   * @var string
   */
  public $targetingOptionId;

  /**
   * @param string
   */
  public function setAdType($adType)
  {
    $this->adType = $adType;
  }
  /**
   * @return string
   */
  public function getAdType()
  {
    return $this->adType;
  }
  /**
   * @param string
   */
  public function setOnScreenPosition($onScreenPosition)
  {
    $this->onScreenPosition = $onScreenPosition;
  }
  /**
   * @return string
   */
  public function getOnScreenPosition()
  {
    return $this->onScreenPosition;
  }
  /**
   * @param string
   */
  public function setTargetingOptionId($targetingOptionId)
  {
    $this->targetingOptionId = $targetingOptionId;
  }
  /**
   * @return string
   */
  public function getTargetingOptionId()
  {
    return $this->targetingOptionId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(OnScreenPositionAssignedTargetingOptionDetails::class, 'Google_Service_DisplayVideo_OnScreenPositionAssignedTargetingOptionDetails');
